USE [{DBName}]

BEGIN TRANSACTION
SET QUOTED_IDENTIFIER ON
SET ARITHABORT ON
SET NUMERIC_ROUNDABORT OFF
SET CONCAT_NULL_YIELDS_NULL ON
SET ANSI_NULLS ON
SET ANSI_PADDING ON
SET ANSI_WARNINGS ON
COMMIT

BEGIN TRANSACTION

  DECLARE @basicPrice BIT
  DECLARE @promPrice BIT
  DECLARE @recPrice BIT
  DECLARE @dealerPrice BIT
  DECLARE @stockLevel BIT

  IF  EXISTS (SELECT * FROM sysobjects WHERE id = OBJECT_ID(N'{DBOwner}[DF_Products_Tax]') AND type = 'D')
  BEGIN
    ALTER TABLE {DBOwner}[qi_Goods] DROP CONSTRAINT [DF_Products_Tax]
  END

  IF EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'{DBOwner}[qi_Goods]') AND name = N'IX_qi_Goods_BasicPriceExclVAT')
  BEGIN
    DROP INDEX {DBOwner}qi_Goods.IX_qi_Goods_BasicPriceExclVAT
    SET @basicPrice = 1
  END

  IF EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'{DBOwner}[qi_Goods]') AND name = N'IX_qi_Goods_PromotionPriceExclVAT')
  BEGIN
    DROP INDEX {DBOwner}qi_Goods.IX_qi_Goods_PromotionPriceExclVAT
    SET @promPrice = 1
  END

  IF EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'{DBOwner}[qi_Goods]') AND name = N'IX_qi_Goods_RecommendedPriceExclVAT')
  BEGIN
    DROP INDEX {DBOwner}qi_Goods.IX_qi_Goods_RecommendedPriceExclVAT
    SET @recPrice = 1
  END

  IF EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'{DBOwner}[qi_Goods]') AND name = N'IX_qi_Goods_StockLevel')
  BEGIN
    DROP INDEX {DBOwner}qi_Goods.IX_qi_Goods_StockLevel
    SET @stockLevel = 1
  END

  IF EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'{DBOwner}[qi_GoodsDealerPrices]') AND name = N'IX_qi_GoodsDealerPrices_DealerCategoryICU_PriceType_GoodsICU')
  BEGIN
    DROP INDEX {DBOwner}qi_GoodsDealerPrices.IX_qi_GoodsDealerPrices_DealerCategoryICU_PriceType_GoodsICU
    SET @dealerPrice = 1
  END

  ALTER TABLE {DBOwner}qi_ExchangeRates ALTER COLUMN ExchangeRate NUMERIC(20, 8) NOT NULL
  ALTER TABLE {DBOwner}qi_Basket ALTER COLUMN Quantity NUMERIC(20, 8) NOT NULL
  ALTER TABLE {DBOwner}qi_ShipmentMethods ALTER COLUMN MaxDimension1 NUMERIC(20, 8) NULL
  ALTER TABLE {DBOwner}qi_ShipmentMethods ALTER COLUMN MaxWeight NUMERIC(20, 8) NULL
  ALTER TABLE {DBOwner}qi_ShipmentMethods ALTER COLUMN MaxDimension2 NUMERIC(20, 8) NULL
  ALTER TABLE {DBOwner}qi_ShipmentMethods ALTER COLUMN MaxDimension3 NUMERIC(20, 8) NULL
  ALTER TABLE {DBOwner}qi_ShipmentMethods ALTER COLUMN MaxDimensionSum NUMERIC(20, 8) NULL
  ALTER TABLE {DBOwner}qi_ShipmentMethods ALTER COLUMN MaxCircumLength NUMERIC(20, 8) NULL
  ALTER TABLE {DBOwner}qi_ShipmentMethods ALTER COLUMN ShipmentOrderDiscountPct NUMERIC(20, 8) NULL
  ALTER TABLE {DBOwner}qi_GoodsSetRelations ALTER COLUMN Quantity NUMERIC(20, 8) NOT NULL
  ALTER TABLE {DBOwner}qi_GoodsSetRelations ALTER COLUMN MinQuantity NUMERIC(20, 8) NULL
  ALTER TABLE {DBOwner}qi_GoodsSetRelations ALTER COLUMN MaxQuantity NUMERIC(20, 8) NULL
  ALTER TABLE {DBOwner}qi_GoodsSetRelations ALTER COLUMN PriceAsPct NUMERIC(20, 8) NULL
  ALTER TABLE {DBOwner}qi_ShipmentServices ALTER COLUMN LimitPrice NUMERIC(20, 8) NULL
  ALTER TABLE {DBOwner}qi_ShipmentServices ALTER COLUMN LimitDimension NUMERIC(20, 8) NULL
  ALTER TABLE {DBOwner}qi_ShipmentServices ALTER COLUMN LimitWeight NUMERIC(20, 8) NULL
  ALTER TABLE {DBOwner}qi_PaymentServices ALTER COLUMN LimitPrice NUMERIC(20, 8) NULL
  ALTER TABLE {DBOwner}qi_AttrValueRedefinitions ALTER COLUMN LimitValue NUMERIC(20, 8) NOT NULL
  ALTER TABLE {DBOwner}qi_GoodsParamValues ALTER COLUMN Value NUMERIC(20, 8) NULL
  ALTER TABLE {DBOwner}qi_GoodsOrganizationPrices_Import ALTER COLUMN QuantityFrom NUMERIC(20, 8) NULL
  ALTER TABLE {DBOwner}qi_GoodsOrganizationPrices_Import ALTER COLUMN QuantityTo NUMERIC(20, 8) NULL
  ALTER TABLE {DBOwner}qi_GoodsOrganizationPrices_Import ALTER COLUMN OrgPriceExclVAT NUMERIC(20, 8) NOT NULL
  ALTER TABLE {DBOwner}qi_GoodsOrganizationPrices_Import ALTER COLUMN OrgPriceInclVAT NUMERIC(20, 8) NOT NULL
  ALTER TABLE {DBOwner}qi_GoodsOrganizationPrices_Import ALTER COLUMN PriceType NUMERIC(20, 8) NULL
  ALTER TABLE {DBOwner}qi_ParamValueRedefinitions ALTER COLUMN LimitValue NUMERIC(20, 8) NOT NULL
  ALTER TABLE {DBOwner}qi_OrderItems ALTER COLUMN Quantity NUMERIC(20, 8) NOT NULL
  ALTER TABLE {DBOwner}qi_OrderItems ALTER COLUMN PriceExclVAT NUMERIC(20, 8) NOT NULL
  ALTER TABLE {DBOwner}qi_OrderItems ALTER COLUMN PriceInclVAT NUMERIC(20, 8) NOT NULL
  ALTER TABLE {DBOwner}qi_OrderItems ALTER COLUMN VATPct NUMERIC(20, 8) NOT NULL
  ALTER TABLE {DBOwner}qi_OrderItems ALTER COLUMN PriceType NUMERIC(20, 8) NULL
  ALTER TABLE {DBOwner}qi_VolumeDiscounts ALTER COLUMN Amount NUMERIC(20, 8) NOT NULL
  ALTER TABLE {DBOwner}qi_VolumeDiscounts ALTER COLUMN DiscountPct NUMERIC(20, 8) NOT NULL
  ALTER TABLE {DBOwner}qi_GoodsDealerPrices ALTER COLUMN QuantityFrom NUMERIC(20, 8) NULL
  ALTER TABLE {DBOwner}qi_GoodsDealerPrices ALTER COLUMN QuantityTo NUMERIC(20, 8) NULL
  ALTER TABLE {DBOwner}qi_GoodsDealerPrices ALTER COLUMN DealerPriceExclVAT NUMERIC(20, 8) NOT NULL
  ALTER TABLE {DBOwner}qi_GoodsDealerPrices ALTER COLUMN DealerPriceInclVAT NUMERIC(20, 8) NOT NULL
  ALTER TABLE {DBOwner}qi_GoodsDealerPrices ALTER COLUMN PriceType NUMERIC(20, 8) NOT NULL
  ALTER TABLE {DBOwner}qi_PaymentMethods ALTER COLUMN PaymentOrderDiscountPct NUMERIC(20, 8) NULL
  ALTER TABLE {DBOwner}qi_GoodsOrganizationPrices ALTER COLUMN QuantityFrom NUMERIC(20, 8) NULL
  ALTER TABLE {DBOwner}qi_GoodsOrganizationPrices ALTER COLUMN QuantityTo NUMERIC(20, 8) NULL
  ALTER TABLE {DBOwner}qi_GoodsOrganizationPrices ALTER COLUMN OrgPriceExclVAT NUMERIC(20, 8) NOT NULL
  ALTER TABLE {DBOwner}qi_GoodsOrganizationPrices ALTER COLUMN OrgPriceInclVAT NUMERIC(20, 8) NOT NULL
  ALTER TABLE {DBOwner}qi_GoodsOrganizationPrices ALTER COLUMN PriceType NUMERIC(20, 8) NULL
  ALTER TABLE {DBOwner}qi_Goods ALTER COLUMN PromotionPriceExclVAT NUMERIC(20, 8) NULL
  ALTER TABLE {DBOwner}qi_Goods ALTER COLUMN PromotionPriceInclVAT NUMERIC(20, 8) NULL
  ALTER TABLE {DBOwner}qi_Goods ALTER COLUMN BasicPriceExclVAT NUMERIC(20, 8) NOT NULL
  ALTER TABLE {DBOwner}qi_Goods ALTER COLUMN BasicPriceInclVAT NUMERIC(20, 8) NOT NULL
  ALTER TABLE {DBOwner}qi_Goods ALTER COLUMN VATPct NUMERIC(20, 8) NOT NULL
  ALTER TABLE {DBOwner}qi_Goods ALTER COLUMN Dimension1 NUMERIC(20, 8) NULL
  ALTER TABLE {DBOwner}qi_Goods ALTER COLUMN Dimension2 NUMERIC(20, 8) NULL
  ALTER TABLE {DBOwner}qi_Goods ALTER COLUMN Dimension3 NUMERIC(20, 8) NULL
  ALTER TABLE {DBOwner}qi_Goods ALTER COLUMN Weight NUMERIC(20, 8) NULL
  ALTER TABLE {DBOwner}qi_Goods ALTER COLUMN Volume NUMERIC(20, 8) NULL
  ALTER TABLE {DBOwner}qi_Goods ALTER COLUMN StockLevel NUMERIC(20, 8) NULL
  ALTER TABLE {DBOwner}qi_Goods ALTER COLUMN RecommendedPriceExclVAT NUMERIC(20, 8) NULL
  ALTER TABLE {DBOwner}qi_Goods ALTER COLUMN RecommendedPriceInclVAT NUMERIC(20, 8) NULL
  ALTER TABLE {DBOwner}qi_Goods ALTER COLUMN QuantityReserved NUMERIC(20, 8) NULL
  ALTER TABLE {DBOwner}qi_Goods ALTER COLUMN QuantityOnWay NUMERIC(20, 8) NULL
  ALTER TABLE {DBOwner}qi_Goods ALTER COLUMN RecyclingFee NUMERIC(20, 8) NULL
  ALTER TABLE {DBOwner}qi_Organizations ALTER COLUMN IndDiscountPctBasic NUMERIC(20, 8) NOT NULL
  ALTER TABLE {DBOwner}qi_Organizations ALTER COLUMN IndDiscountPctDealer NUMERIC(20, 8) NULL
  ALTER TABLE {DBOwner}qi_Organizations ALTER COLUMN IndDiscountPctPromotion NUMERIC(20, 8) NULL
  ALTER TABLE {DBOwner}qi_Organizations ALTER COLUMN IndDiscountPctOrgFixed NUMERIC(20, 8) NULL
  ALTER TABLE {DBOwner}qi_Organizations ALTER COLUMN IndDiscountPctOrgPromotion NUMERIC(20, 8) NULL
  ALTER TABLE {DBOwner}qi_Organizations ALTER COLUMN IndDiscountPctSetItem NUMERIC(20, 8) NULL
  ALTER TABLE {DBOwner}qi_Orders ALTER COLUMN TotalPriceExclVAT NUMERIC(20, 8) NOT NULL
  ALTER TABLE {DBOwner}qi_Orders ALTER COLUMN TotalPriceInclVAT NUMERIC(20, 8) NOT NULL
  ALTER TABLE {DBOwner}qi_Orders ALTER COLUMN VolumeDiscountPct NUMERIC(20, 8) NULL
  ALTER TABLE {DBOwner}qi_Orders ALTER COLUMN AccountingRate NUMERIC(20, 8) NULL
  ALTER TABLE {DBOwner}qi_Orders ALTER COLUMN OrderDiscountPct NUMERIC(20, 8) NULL
  ALTER TABLE {DBOwner}qi_Orders ALTER COLUMN FinalPriceExclVAT NUMERIC(20, 8) NULL
  ALTER TABLE {DBOwner}qi_Orders ALTER COLUMN FinalPriceInclVAT NUMERIC(20, 8) NULL
  ALTER TABLE {DBOwner}qi_Orders ALTER COLUMN FinalVAT NUMERIC(20, 8) NULL

  IF (@basicPrice = 1)
  BEGIN
    CREATE NONCLUSTERED INDEX [IX_qi_Goods_BasicPriceExclVAT] ON {DBOwner}[qi_Goods](BasicPriceExclVAT ASC) 
                              WITH (PAD_INDEX = OFF, ALLOW_PAGE_LOCKS = ON, ALLOW_ROW_LOCKS = ON, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, SORT_IN_TEMPDB = OFF, FILLFACTOR = 90) ON [PRIMARY];
  END

  IF (@promPrice = 1)
  BEGIN
    CREATE NONCLUSTERED INDEX [IX_qi_Goods_PromotionPriceExclVAT] ON {DBOwner}[qi_Goods](PromotionPriceExclVAT ASC) 
                              WITH (PAD_INDEX = OFF, ALLOW_PAGE_LOCKS = ON, ALLOW_ROW_LOCKS = ON, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, SORT_IN_TEMPDB = OFF, FILLFACTOR = 90) ON [PRIMARY];
  END

  IF (@recPrice = 1)
  BEGIN
    CREATE NONCLUSTERED INDEX [IX_qi_Goods_RecommendedPriceExclVAT] ON {DBOwner}[qi_Goods](RecommendedPriceExclVAT ASC) 
                              WITH (PAD_INDEX = OFF, ALLOW_PAGE_LOCKS = ON, ALLOW_ROW_LOCKS = ON, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, SORT_IN_TEMPDB = OFF, FILLFACTOR = 90) ON [PRIMARY];
  END

  IF (@stockLevel = 1)
  BEGIN
    CREATE NONCLUSTERED INDEX [IX_qi_Goods_PromotionPriceExclVAT] ON {DBOwner}[qi_Goods](StockLevel ASC) 
                              WITH (PAD_INDEX = OFF, ALLOW_PAGE_LOCKS = ON, ALLOW_ROW_LOCKS = ON, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, SORT_IN_TEMPDB = OFF, FILLFACTOR = 90) ON [PRIMARY];
  END

  IF (@dealerPrice = 1)
  BEGIN
	CREATE NONCLUSTERED INDEX [IX_qi_GoodsDealerPrices_DealerCategoryICU_PriceType_GoodsICU] ON {DBOwner}[qi_GoodsDealerPrices] 
	(
		[DealerCategoryIC] ASC,
		[DealerCategoryU] ASC,
		[PriceType] ASC,
		[GoodsIC] ASC,
		[GoodsU] ASC
	)
	INCLUDE ( [DealerPriceExclVAT], [DealerPriceInclVAT] ) WITH (SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF) ON [PRIMARY]
  END

COMMIT